/*
 * Decompiled with CFR 0.152.
 */
package cds.tools.hpxwcs;

import cds.tools.hpxwcs.FillingCurve2D;
import cds.tools.hpxwcs.SetableXY;
import cds.tools.hpxwcs.SetableXYImpl;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public final class Tile2HPX {
    private static final double PI_OVER_FOUR = 0.7853981633974483;
    public static final FillingCurve2D FC = new FillingCurve2D(){

        @Override
        public final long xy2hash(double x, double y) {
            return this.ij2hash((int)x, (int)y);
        }

        @Override
        public final long ij2hash(int i, int j) {
            long h = (long)j << 32;
            h |= (long)i;
            h = (0xFFFF0000L & h) << 16 | (0xFFFF00000000L & h) >>> 16 | 0xFFFF00000000FFFFL & h;
            h = (0xFF000000FF00L & h) << 8 | (0xFF000000FF0000L & h) >>> 8 | 0xFF0000FFFF0000FFL & h;
            h = (0xF000F000F000F0L & h) << 4 | (0xF000F000F000F00L & h) >>> 4 | 0xF00FF00FF00FF00FL & h;
            h = (0xC0C0C0C0C0C0C0CL & h) << 2 | (0x3030303030303030L & h) >>> 2 | 0xC3C3C3C3C3C3C3C3L & h;
            h = (0x2222222222222222L & h) << 1 | (0x4444444444444444L & h) >>> 1 | 0x9999999999999999L & h;
            return h;
        }

        @Override
        public final long i02hash(int i) {
            long h = i;
            h = (0xFFFF0000L & h) << 16 | 0xFFFFL & h;
            h = (h << 8 | h) & 0xFF00FF00FF00FFL;
            h = (h << 4 | h) & 0xF0F0F0F0F0F0F0FL;
            h = (h << 2 | h) & 0x3333333333333333L;
            h = (h << 1 | h) & 0x5555555555555555L;
            return h;
        }

        @Override
        public final long hash2ij(long h) {
            h = (0x2222222222222222L & h) << 1 | (0x4444444444444444L & h) >>> 1 | 0x9999999999999999L & h;
            h = (0xC0C0C0C0C0C0C0CL & h) << 2 | (0x3030303030303030L & h) >>> 2 | 0xC3C3C3C3C3C3C3C3L & h;
            h = (0xF000F000F000F0L & h) << 4 | (0xF000F000F000F00L & h) >>> 4 | 0xF00FF00FF00FF00FL & h;
            h = (0xFF000000FF00L & h) << 8 | (0xFF000000FF0000L & h) >>> 8 | 0xFF0000FFFF0000FFL & h;
            h = (0xFFFF0000L & h) << 16 | (0xFFFF00000000L & h) >>> 16 | 0xFFFF00000000FFFFL & h;
            return h;
        }

        @Override
        public final long hash2i0(long h) {
            assert ((0x3333333333333333L & h) == 0L);
            h = (h >> 1 | h) & 0x3333333333333333L;
            h = (h >> 2 | h) & 0xF0F0F0F0F0F0F0FL;
            h = (h >> 4 | h) & 0xFF00FF00FF00FFL;
            h = (h >> 8 | h) & 0xFFFF0000FFFFL;
            return h;
        }

        @Override
        public final int ij2i(long ij) {
            return (int)ij;
        }

        @Override
        public final int ij2j(long ij) {
            return (int)(ij >>> 32);
        }
    };
    private final int order;
    private final int inNside;
    private final WCSFrame frame;
    private final int nsideTile;
    private final int nsidePix;
    private final int twiceDepth;
    private final long xyMask;

    public Tile2HPX(int tileOrder, int inTileNside, WCSFrame wcsFrame) {
        this.order = tileOrder;
        this.inNside = inTileNside;
        this.frame = wcsFrame;
        this.nsideTile = 1 << this.order;
        this.nsidePix = this.nsideTile * this.inNside;
        this.twiceDepth = tileOrder << 1;
        this.xyMask = (1L << this.twiceDepth) - 1L;
    }

    public void center(long hash, SetableXY result) {
        int d0h = (int)(hash >> this.twiceDepth);
        hash = FC.hash2ij(hash & this.xyMask);
        int iInD0h = FC.ij2i(hash);
        int jInD0h = FC.ij2j(hash);
        int lInD0h = iInD0h - jInD0h;
        int hInD0h = iInD0h + jInD0h - (this.nsideTile - 1);
        int d0hBy4Quotient = d0h >> 2;
        int d0hMod4 = d0h - (d0hBy4Quotient << 2);
        int hD0h = 1 - d0hBy4Quotient;
        int lD0h = d0hMod4 << 1;
        if (hD0h == 0 && (lD0h == 6 || lD0h == 4 && lInD0h > 0) || hD0h != 0 && ++lD0h > 3) {
            lD0h -= 8;
        }
        result.setXY(0.7853981633974483 * ((double)lD0h + (double)lInD0h / (double)this.nsideTile), 0.7853981633974483 * ((double)hD0h + (double)hInD0h / (double)this.nsideTile));
    }

    public final Map<String, String> toFitsHeader(long tileIpix) throws Exception {
        SetableXYImpl xy = new SetableXYImpl();
        this.center(tileIpix, xy);
        double centreX = Math.toDegrees(xy.x());
        double centreY = Math.toDegrees(xy.y());
        double scale = 45.0 / (double)this.nsidePix;
        double crPix1 = (double)(this.inNside + 1) / 2.0 - 0.5 * (-centreX / scale + centreY / scale);
        double crPix2 = (double)(this.inNside + 1) / 2.0 - 0.5 * (-centreX / scale - centreY / scale);
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        output.put("NAXIS  ", "                    2 / number of data axes");
        output.put("NAXIS1 ", String.format(Locale.US, "%21d / length of data axis 1", this.inNside));
        output.put("NAXIS2 ", String.format(Locale.US, "%21d / length of data axis 1", this.inNside));
        output.put("CRPIX1 ", String.format(Locale.US, "%21.1f / Coordinate reference pixel", crPix1));
        output.put("CRPIX2 ", String.format(Locale.US, "%21.1f / Coordinate reference pixel", crPix2));
        output.put("CD1_1  ", String.format(Locale.US, "%21.13E / Transformation matrix (rot + scale)", -scale));
        output.put("CD1_2  ", String.format(Locale.US, "%21.13E / Transformation matrix (rot + scale)", -scale));
        output.put("CD2_1  ", String.format(Locale.US, "%21.13E / Transformation matrix (rot + scale)", scale));
        output.put("CD2_2  ", String.format(Locale.US, "%21.13E / Transformation matrix (rot + scale)", -scale));
        output.put("CTYPE1 ", " '" + this.frame.lonLabel + "-HPX'           / Longitude in an HPX projection");
        output.put("CTYPE2 ", " '" + this.frame.latLabel + "-HPX'           /  Latitude in an HPX projection");
        output.put("CRVAL1 ", "                   0. / [deg] Longitude at the reference point");
        output.put("CRVAL2 ", "                   0. / [deg]  Latitude at the reference point");
        output.put("PV2_1  ", "                   4  / HPX H parameter (longitude)");
        output.put("PV2_2  ", "                   3  / HPX K parameter  (latitude)");
        return output;
    }

    public static final Map<String, String> toFitsHeader(int tileOrder, long tileIpix, int nPixelX, WCSFrame frame) throws Exception {
        return new Tile2HPX(tileOrder, nPixelX, frame).toFitsHeader(tileIpix);
    }

    public static enum WCSFrame {
        EQU("RA--", "DEC-"),
        GAL("GLON", "GLAT"),
        ECL("ELON", "ELAT");

        private final String lonLabel;
        private final String latLabel;

        private WCSFrame(String lonLabel, String latLabel) {
            this.lonLabel = lonLabel;
            this.latLabel = latLabel;
        }
    }
}

